﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CashierCrisis.Core;
using CashierCrisis.Entities;
using CashierCrisis.Graphs;
using Microsoft.Xna.Framework;

namespace CashierCrisis.Behaviors
{
    public class FollowPath : Action
    {
        private int _index = 0;
        private List<Vector2> _path = new List<Vector2>();
        private SteeringComponent _steering;

        public List<Vector2> Path
        {
            get { return _path; }
            set { _path = value; }
        }


        public override Status Execute(GameTime gameTime)
        {
            _steering = Entity.GetComponent("steering") as SteeringComponent;

            if (_index < _path.Count)
            {


                Vector2 currentPosition = _path[_index];
                _steering.TargetPosition = currentPosition;
                _steering.ToggleSteeringBehavior(SteeringBehavior.Arrive, true);

                if(Entity.Position.Close(currentPosition, 0.9f))
                {
                    if (_index + 1 < _path.Count - 1)
                    {
                        _index++;
                        return Running;
                    }
                    _steering.ToggleSteeringBehavior(SteeringBehavior.Arrive, false);
                    return Completed;

                }
                return Running;
            }
            return Failed;
        }
     
    }
}
